<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class InvoicePayment extends Model
{
    use HasUuids;

    protected $fillable = [
        'invoice_id', 'payment_id', 'amount', 'payment_date', 'payment_method',
        'transaction_id', 'notes',
    ];

    protected $casts = ['payment_date' => 'datetime'];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    public function payment()
    {
        return $this->belongsTo(Payment::class);
    }
}
