<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class InvoiceTax extends Model
{
    use HasUuids;

    protected $fillable = ['invoice_id', 'tax_rate_id', 'tax_type', 'rate', 'tax_amount', 'description'];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    public function taxRate()
    {
        return $this->belongsTo(TaxRate::class);
    }
}
