<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class JournalEntry extends Model
{
    use HasUuids;

    protected $fillable = [
        'entry_number', 'date', 'description', 'reference', 'total_debit',
        'total_credit', 'status', 'created_by', 'approved_by', 'approved_at', 'branch_id',
    ];

    protected $casts = ['date' => 'datetime', 'approved_at' => 'datetime'];

    public function items()
    {
        return $this->hasMany(JournalEntryItem::class, 'entry_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
}
