<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class KnowledgeBaseArticle extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'title', 'slug', 'content', 'excerpt', 'category_id',
        'author_id', 'status', 'view_count', 'helpful_count',
        'is_featured', 'is_public', 'published_at',
    ];

    protected $casts = [
        'view_count' => 'integer',
        'helpful_count' => 'integer',
        'is_featured' => 'boolean',
        'is_public' => 'boolean',
        'published_at' => 'datetime',
    ];

    public function category()
    {
        return $this->belongsTo(KnowledgeBaseCategory::class, 'category_id');
    }

    public function author()
    {
        return $this->belongsTo(User::class, 'author_id');
    }
}
