<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class KnowledgeBaseCategory extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'name', 'slug', 'description', 'icon', 'sort_order',
        'is_active', 'parent_id',
    ];

    protected $casts = [
        'sort_order' => 'integer',
        'is_active' => 'boolean',
    ];

    public function parent()
    {
        return $this->belongsTo(KnowledgeBaseCategory::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(KnowledgeBaseCategory::class, 'parent_id');
    }

    public function articles()
    {
        return $this->hasMany(KnowledgeBaseArticle::class, 'category_id');
    }
}
