<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class KnowledgeBaseRating extends Model
{
    use HasUuids;

    protected $fillable = ['article_id', 'user_id', 'rating', 'helpful', 'feedback', 'ip_address', 'user_agent'];

    protected $casts = ['helpful' => 'boolean'];

    public function article()
    {
        return $this->belongsTo(KnowledgeBaseArticle::class, 'article_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
