<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Lead extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'lead_number', 'customer_id', 'first_name', 'last_name',
        'email', 'phone', 'company', 'source', 'campaign_id',
        'status', 'priority', 'estimated_value', 'assigned_to', 'score',
    ];

    protected $casts = [
        'estimated_value' => 'decimal:2',
    ];

    public function customerProfile()
    {
        return $this->belongsTo(CustomerProfile::class, 'customer_id');
    }

    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }

    public function assignedTo()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    public function activities()
    {
        return $this->hasMany(LeadActivity::class)->latest();
    }
}
