<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class LeadActivity extends Model
{
    use HasUuids;

    protected $fillable = ['lead_id', 'type', 'title', 'description', 'performed_by', 'metadata'];

    protected $casts = ['metadata' => 'array'];

    public function lead()
    {
        return $this->belongsTo(Lead::class);
    }

    public function performer()
    {
        return $this->belongsTo(User::class, 'performed_by');
    }
}
