<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class LeadCommunication extends Model
{
    use HasUuids;

    protected $fillable = [
        'lead_id', 'type', 'direction', 'subject', 'content', 'status',
        'scheduled_at', 'sent_at', 'delivered_at', 'opened_at', 'clicked_at', 'replied_at', 'metadata',
    ];

    protected $casts = [
        'scheduled_at' => 'datetime', 'sent_at' => 'datetime', 'delivered_at' => 'datetime',
        'opened_at' => 'datetime', 'clicked_at' => 'datetime', 'replied_at' => 'datetime', 'metadata' => 'array',
    ];
}
