<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class MaintenancePart extends Model
{
    use HasUuids;

    protected $fillable = ['part_number', 'name', 'category', 'description', 'cost', 'price', 'quantity', 'min_stock', 'max_stock', 'location', 'supplier', 'status', 'barcode', 'image_url', 'created_by'];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
