<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class MaintenanceRecord extends Model
{
    use HasUuids;

    protected $fillable = ['vehicle_id', 'schedule_id', 'type', 'title', 'description', 'cost', 'technician', 'start_date', 'end_date', 'status', 'notes', 'parts', 'labor_hours', 'odometer', 'created_by'];

    protected $casts = ['start_date' => 'datetime', 'end_date' => 'datetime', 'parts' => 'array'];

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function schedule()
    {
        return $this->belongsTo(MaintenanceSchedule::class);
    }

    public function usageItems()
    {
        return $this->hasMany(MaintenanceUsageItem::class);
    }
}
