<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class MaintenanceSchedule extends Model
{
    use HasUuids;

    protected $fillable = ['vehicle_id', 'type', 'title', 'description', 'interval', 'interval_km', 'last_service', 'next_service', 'estimated_cost', 'priority', 'is_active', 'created_by'];

    protected $casts = ['last_service' => 'datetime', 'next_service' => 'datetime', 'is_active' => 'boolean'];

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function records()
    {
        return $this->hasMany(MaintenanceRecord::class, 'schedule_id');
    }
}
