<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MaintenanceUsageItem extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = [
        'maintenance_record_id',
        'product_id',
        'description',
        'quantity',
        'unit_cost',
        'total_cost',
        'batch_number',
        'is_stock_deducted',
    ];

    protected $casts = [
        'unit_cost' => 'decimal:2',
        'total_cost' => 'decimal:2',
        'is_stock_deducted' => 'boolean',
    ];

    public function maintenanceRecord()
    {
        return $this->belongsTo(MaintenanceRecord::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
