<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class MarketingAutomation extends Model
{
    use HasUuids;

    protected $fillable = [
        'campaign_id', 'name', 'trigger_type', 'trigger_config', 'action_type',
        'action_config', 'is_active', 'delay_minutes', 'executions_count', 'metadata',
    ];

    protected $casts = ['trigger_config' => 'array', 'action_config' => 'array', 'is_active' => 'boolean', 'metadata' => 'array'];

    public function campaign()
    {
        return $this->belongsTo(MarketingCampaign::class, 'campaign_id');
    }
}
