<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class MarketingCampaign extends Model
{
    use HasUuids;

    protected $fillable = [
        'name', 'description', 'type', 'category', 'status', 'start_date', 'end_date',
        'budget', 'target_audience', 'content', 'channels', 'goals', 'created_by',
        'approved_by', 'approved_at', 'branch_id', 'tags', 'attachments', 'metadata',
    ];

    protected $casts = [
        'start_date' => 'datetime', 'end_date' => 'datetime', 'approved_at' => 'datetime',
        'target_audience' => 'array', 'content' => 'array', 'channels' => 'array',
        'goals' => 'array', 'tags' => 'array', 'attachments' => 'array', 'metadata' => 'array',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function members()
    {
        return $this->hasMany(CampaignMember::class, 'campaign_id');
    }

    public function leads()
    {
        return $this->hasMany(Lead::class, 'campaign_id');
    }

    public function automations()
    {
        return $this->hasMany(MarketingAutomation::class, 'campaign_id');
    }
}
