<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class MarketingMetric extends Model
{
    use HasUuids;

    protected $fillable = ['date', 'period', 'campaigns_sent', 'emails_sent', 'emails_opened', 'emails_clicked', 'sms_sent', 'sms_delivered', 'leads_generated', 'leads_converted', 'conversion_rate', 'cost_per_lead', 'cost_per_acquisition', 'revenue_generated', 'roi', 'top_campaigns', 'branch_id', 'metadata'];

    protected $casts = ['date' => 'datetime', 'top_campaigns' => 'array', 'metadata' => 'array'];
}
