<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class Media extends Model
{
    use HasUuids;

    protected $fillable = ['filename', 'original_name', 'path', 'url', 'thumbnail_url', 'mime_type', 'size', 'width', 'height', 'alt_text', 'title', 'description', 'tags', 'category', 'entity_id', 'is_public', 'is_featured', 'order', 'metadata', 'created_by'];

    protected $casts = ['is_public' => 'boolean', 'is_featured' => 'boolean'];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
