<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Opportunity extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'customer_id', 'title', 'description', 'stage',
        'value', 'currency', 'probability', 'expected_close_date',
        'vehicle_id',
    ];

    protected $casts = [
        'value' => 'decimal:2',
        'probability' => 'integer',
        'expected_close_date' => 'datetime',
    ];

    public function customerProfile()
    {
        return $this->belongsTo(CustomerProfile::class, 'customer_id');
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }
}
