<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasUuids;

    protected $fillable = ['order_number', 'customer_id', 'status', 'subtotal', 'tax_amount', 'shipping_amount', 'total', 'shipping_address', 'billing_address', 'payment_method', 'payment_status', 'notes', 'created_by'];

    protected $casts = ['shipping_address' => 'array', 'billing_address' => 'array'];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function payments()
    {
        return $this->hasMany(OrderPayment::class);
    }
}
