<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class OrderPayment extends Model
{
    use HasUuids;

    protected $fillable = ['order_id', 'amount', 'currency', 'status', 'payment_method', 'transaction_id', 'receipt_url', 'notes'];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }
}
