<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids, LogsActivity, SoftDeletes;

    protected $fillable = [
        'booking_id', 'booking_type', 'amount', 'currency', 'status',
        'payment_method', 'transaction_id', 'receipt_url', 'description',
        'notes', 'branch_id', 'customer_id', 'invoice_id',
        'service_booking_id', 'test_drive_booking_id',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    public function serviceBooking()
    {
        return $this->belongsTo(ServiceBooking::class);
    }

    public function testDriveBooking()
    {
        return $this->belongsTo(TestDriveBooking::class);
    }
}
