<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class PaymentGatewayConfig extends Model
{
    use HasUuids;

    protected $fillable = [
        'name', 'gateway', 'api_key', 'secret_key', 'merchant_id',
        'is_active', 'config', 'test_mode',
    ];

    protected $casts = ['is_active' => 'boolean', 'config' => 'array', 'test_mode' => 'boolean'];

    protected $hidden = ['api_key', 'secret_key'];
}
