<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class PerformanceMetric extends Model
{
    use HasUuids;

    protected $fillable = [
        'employee_id', 'period', 'period_label', 'bookings_handled', 'average_handling_time',
        'customer_rating', 'conversion_rate', 'revenue_generated', 'tasks_completed',
        'customer_satisfaction', 'response_time', 'follow_up_rate', 'upsell_success',
        'overall_score', 'metrics_metadata', 'notes',
    ];

    protected $casts = ['metrics_metadata' => 'array'];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
