<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class PerformanceReview extends Model
{
    use HasUuids;

    protected $fillable = [
        'employee_id', 'reviewer_id', 'period', 'rating', 'goals',
        'achievements', 'areas_for_improvement', 'comments', 'status',
    ];

    protected $casts = ['goals' => 'array', 'achievements' => 'array', 'areas_for_improvement' => 'array'];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function reviewer()
    {
        return $this->belongsTo(User::class, 'reviewer_id');
    }

    public function getReviewDateAttribute()
    {
        return $this->created_at;
    }

    public function getOverallRatingAttribute(): int
    {
        $map = [
            'UNSATISFACTORY' => 1,
            'NEEDS_IMPROVEMENT' => 2,
            'SATISFACTORY' => 3,
            'GOOD' => 4,
            'EXCELLENT' => 5,
        ];

        return $map[$this->rating] ?? 3;
    }
}
