<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasUuids;

    protected $fillable = ['name', 'description', 'price', 'cost_price', 'category', 'images', 'in_stock', 'quantity', 'bin_location', 'featured', 'status', 'created_by'];

    protected $casts = [
        'images' => 'array', 
        'in_stock' => 'boolean', 
        'featured' => 'boolean',
        'price' => 'decimal:2',
        'cost_price' => 'decimal:2',
    ];

    public function orderItems()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function reviews()
    {
        return $this->hasMany(ProductReview::class);
    }
}
