<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class Promotion extends Model
{
    use HasUuids;

    protected $fillable = ['title', 'description', 'type', 'value', 'code', 'start_date', 'end_date', 'usage_limit', 'used_count', 'active', 'created_by'];

    protected $casts = ['start_date' => 'datetime', 'end_date' => 'datetime', 'active' => 'boolean'];

    public function usages()
    {
        return $this->hasMany(PromotionUsage::class);
    }
}
