<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Quotation extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'quotation_number', 'customer_id', 'branch_id', 'status',
        'issue_date', 'valid_until', 'subtotal', 'tax_amount',
        'total_amount', 'currency', 'notes', 'terms',
        'created_by_id', 'converted_to_invoice_id',
    ];

    protected $casts = [
        'issue_date' => 'datetime',
        'valid_until' => 'datetime',
        'subtotal' => 'decimal:2',
        'tax_amount' => 'decimal:2',
        'total_amount' => 'decimal:2',
    ];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by_id');
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'converted_to_invoice_id');
    }

    public function items()
    {
        return $this->hasMany(QuotationItem::class);
    }
}
