<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RoleTemplate extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'name',
        'description',
        'role',
        'permissions',
        'is_active',
        'is_system',
    ];

    protected $casts = [
        'permissions' => 'array',
        'is_active' => 'boolean',
        'is_system' => 'boolean',
    ];

    public function permissionsRel()
    {
        return $this->belongsToMany(Permission::class, 'role_template_permissions', 'template_id', 'permission_id');
    }

    public function users()
    {
        return $this->hasMany(User::class, 'role_template_id');
    }
}
