<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class SalaryAdvance extends Model
{
    use HasUuids;

    protected $fillable = [
        'employee_id', 'requested_by', 'amount', 'status', 'reason', 'requested_at',
        'approved_by', 'approved_at', 'disbursed_at', 'repayment_start', 'repayment_months',
        'repayment_schedule', 'repaid_amount', 'next_due_date', 'notes', 'metadata',
    ];

    protected $casts = [
        'requested_at' => 'datetime', 'approved_at' => 'datetime', 'disbursed_at' => 'datetime',
        'repayment_start' => 'datetime', 'next_due_date' => 'datetime',
        'repayment_schedule' => 'array', 'metadata' => 'array',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function requester()
    {
        return $this->belongsTo(User::class, 'requested_by');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }
}
