<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class SalesFunnel extends Model
{
    use HasUuids;

    protected $fillable = ['name', 'description', 'stages', 'is_active', 'is_default', 'created_by', 'branch_id'];

    protected $casts = ['stages' => 'array', 'is_active' => 'boolean', 'is_default' => 'boolean'];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function opportunities()
    {
        return $this->hasMany(Opportunity::class);
    }
}
