<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class SalesTarget extends Model
{
    use HasUuids;

    protected $fillable = ['name', 'description', 'type', 'target_value', 'period', 'start_date', 'end_date', 'assigned_to', 'assigned_type', 'progress', 'status', 'branch_id', 'metadata'];

    protected $casts = ['start_date' => 'datetime', 'end_date' => 'datetime', 'metadata' => 'array'];
}
