<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class SecurityLog extends Model
{
    use HasUuids;

    protected $fillable = ['user_id', 'action', 'severity', 'description', 'ip_address', 'user_agent', 'metadata'];

    protected $casts = ['metadata' => 'array'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
