<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceBooking extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'customer_id', 'vehicle_id', 'service_type_id', 'time_slot_id',
        'date', 'time_slot', 'status', 'notes', 'total_price',
        'payment_status', 'payment_id', 'reminder_sent',
    ];

    protected $casts = [
        'date' => 'datetime',
        'total_price' => 'decimal:2',
        'reminder_sent' => 'boolean',
    ];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function serviceType()
    {
        return $this->belongsTo(ServiceType::class); // We need to create ServiceType model
    }
}
