<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class ServiceEvaluation extends Model
{
    use HasUuids;

    protected $fillable = ['customer_id', 'service_type', 'service_id', 'overall_rating', 'quality_rating', 'speed_rating', 'staff_rating', 'value_rating', 'recommendations', 'would_recommend', 'feedback', 'status', 'reviewed_by', 'reviewed_at', 'response', 'tags', 'attachments', 'is_public'];

    protected $casts = ['would_recommend' => 'boolean', 'is_public' => 'boolean', 'reviewed_at' => 'datetime', 'tags' => 'array', 'attachments' => 'array'];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function reviewer()
    {
        return $this->belongsTo(User::class, 'reviewed_by');
    }
}
