<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceType extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids, \Illuminate\Database\Eloquent\Factories\HasFactory;

    protected $fillable = [
        'name', 'description', 'duration', 'price', 'category', 'is_active', 'image',
    ];

    protected $casts = [
        'duration' => 'integer',
        'price' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    public function serviceBookings()
    {
        return $this->hasMany(ServiceBooking::class);
    }
}
