<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SiteSetting extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'site_title', 'site_description', 'logo_url', 'favicon_url',
        'contact_email', 'contact_phone', 'contact_address',
        'primary_color', 'social_links', 'is_active',
    ];

    protected $casts = [
        'social_links' => 'array',
        'is_active' => 'boolean',
    ];
}
