<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class Task extends Model
{
    use HasUuids;

    protected $fillable = ['title', 'description', 'assigned_to', 'assigned_by', 'priority', 'status', 'due_date', 'completed_at', 'tags', 'branch_id'];

    protected $casts = ['due_date' => 'datetime', 'completed_at' => 'datetime', 'tags' => 'array'];

    public function assignee()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    public function assigner()
    {
        return $this->belongsTo(User::class, 'assigned_by');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function comments()
    {
        return $this->hasMany(TaskComment::class);
    }
}
