<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class TaxRecord extends Model
{
    use HasUuids;

    protected $fillable = [
        'type', 'period', 'amount', 'due_date', 'paid_date', 'status',
        'reference', 'documents', 'notes', 'branch_id', 'created_by', 'approved_by',
    ];

    protected $casts = ['due_date' => 'datetime', 'paid_date' => 'datetime', 'documents' => 'array'];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
