<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TestDriveBooking extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'customer_id', 'vehicle_id', 'date', 'time_slot',
        'status', 'payment_status', 'notes',
    ];

    protected $casts = [
        'date' => 'datetime',
    ];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }
}
