<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class Ticket extends Model
{
    use HasUuids;

    protected $table = 'support_tickets';

    protected $fillable = [
        'ticket_number', 'customer_id', 'subject', 'description',
        'category', 'priority', 'status', 'assigned_to',
        'assigned_by', 'assigned_at', 'resolved_at',
        'resolution', 'resolution_by', 'branch_id',
    ];

    protected $casts = [
        'assigned_at' => 'datetime',
        'resolved_at' => 'datetime',
    ];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function assignedTo()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    public function comments()
    {
        return $this->hasMany(TicketComment::class, 'ticket_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
}
