<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class TicketTimeline extends Model
{
    use HasUuids;

    protected $fillable = ['ticket_id', 'action', 'description', 'performed_by', 'metadata'];

    protected $casts = ['metadata' => 'array'];

    public function ticket()
    {
        return $this->belongsTo(SupportTicket::class, 'ticket_id');
    }

    public function performer()
    {
        return $this->belongsTo(User::class, 'performed_by');
    }
}
