<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class TrainingRecord extends Model
{
    use HasUuids;

    protected $fillable = [
        'employee_id', 'training_name', 'description', 'start_date', 'end_date',
        'cost', 'provider', 'certificate', 'status', 'feedback',
    ];

    protected $casts = ['start_date' => 'datetime', 'end_date' => 'datetime'];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
