<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'reference_id', 'branch_id', 'type', 'category', 'amount',
        'currency', 'description', 'date', 'payment_method',
        'reference', 'customer_id', 'invoice_id',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'date' => 'datetime',
    ];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }
}
