<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VehicleImage extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    public $timestamps = false;

    protected $fillable = ['vehicle_id', 'image_url', 'alt_text', 'is_primary', 'order'];

    protected $casts = [
        'is_primary' => 'boolean',
        'order' => 'integer',
    ];

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }
}
