<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VehiclePricing extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $table = 'vehicle_pricing';

    protected $fillable = [
        'vehicle_id', 'base_price', 'discount_price', 'discount_percentage',
        'taxes', 'fees', 'total_price', 'currency', 'has_discount', 'discount_expires',
    ];

    protected $casts = [
        'base_price' => 'decimal:2',
        'discount_price' => 'decimal:2',
        'discount_percentage' => 'decimal:2',
        'taxes' => 'decimal:2',
        'fees' => 'decimal:2',
        'total_price' => 'decimal:2',
        'has_discount' => 'boolean',
        'discount_expires' => 'datetime',
    ];

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }
}
