<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class Warranty extends Model
{
    use HasUuids;

    protected $fillable = ['warranty_number', 'contract_id', 'vehicle_id', 'type', 'start_date', 'end_date', 'coverage', 'terms', 'status'];

    protected $casts = ['start_date' => 'datetime', 'end_date' => 'datetime', 'coverage' => 'array'];

    public function contract()
    {
        return $this->belongsTo(Contract::class);
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function claims()
    {
        return $this->hasMany(WarrantyClaim::class);
    }
}
