<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class WarrantyClaim extends Model
{
    use HasUuids;

    protected $fillable = ['claim_number', 'warranty_id', 'vehicle_id', 'customer_id', 'description', 'claim_date', 'status', 'estimated_cost', 'actual_cost', 'approved_by', 'approved_at', 'resolved_at', 'resolution', 'attachments', 'created_by'];

    protected $casts = ['claim_date' => 'datetime', 'approved_at' => 'datetime', 'resolved_at' => 'datetime', 'attachments' => 'array'];

    public function warranty()
    {
        return $this->belongsTo(Warranty::class);
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function getIssueTypeAttribute(): string
    {
        if (preg_match('/^\[(.*?)\]/', (string) $this->description, $matches)) {
            return $matches[1];
        }

        return 'GENERAL';
    }
}
