<?php

namespace App\Notifications;

use App\Models\ServiceBooking;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class BookingConfirmedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        private ServiceBooking $booking
    ) {}

    public function via(object $notifiable): array
    {
        return ['database', 'mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('تأكيد حجز الموعد')
            ->greeting('مرحباً '.$notifiable->name)
            ->line('تم تأكيد حجز موعدك بنجاح.')
            ->line('التاريخ: '.$this->booking->date->format('Y-m-d'))
            ->line('الوقت: '.$this->booking->time_slot)
            ->action('عرض الحجز', url('/customer/bookings/'.$this->booking->id))
            ->line('نتطلع لخدمتك!');
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'booking_confirmed',
            'booking_id' => $this->booking->id,
            'date' => $this->booking->date->format('Y-m-d'),
            'time_slot' => $this->booking->time_slot,
            'message' => 'تم تأكيد حجز موعدك بتاريخ '.$this->booking->date->format('Y-m-d'),
        ];
    }
}
