<?php

namespace App\Notifications;

use App\Models\Lead;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class HotLeadNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public Lead $lead
    ) {}

    public function via(object $notifiable): array
    {
        return ['database']; // Can add 'mail' later if configured
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->line('A lead has become HOT!')
                    ->action('View Lead', route('admin.crm.leads.index', ['search' => $this->lead->email]))
                    ->line('Lead Score: ' . $this->lead->score);
    }

    public function toArray(object $notifiable): array
    {
        return [
            'lead_id' => $this->lead->id,
            'message' => 'Hot Lead Detected: ' . $this->lead->first_name . ' ' . $this->lead->last_name . ' (Score: ' . $this->lead->score . ')',
            'action_url' => route('admin.crm.leads.index', ['search' => $this->lead->email]),
            'icon' => 'fire',
            'color' => 'red',
        ];
    }
}
