<?php

namespace App\Notifications;

use App\Models\LeaveRequest;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class LeaveRequestNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        private LeaveRequest $leave,
        private string $employeeName
    ) {}

    public function via(object $notifiable): array
    {
        return ['database'];
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'leave_request',
            'leave_id' => $this->leave->id,
            'employee_name' => $this->employeeName,
            'leave_type' => $this->leave->type,
            'start_date' => $this->leave->start_date->format('Y-m-d'),
            'end_date' => $this->leave->end_date->format('Y-m-d'),
            'message' => $this->employeeName.' طلب إجازة من '.$this->leave->start_date->format('Y-m-d').' إلى '.$this->leave->end_date->format('Y-m-d'),
        ];
    }
}
